/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.client;

import com.mojang.blaze3d.systems.RenderSystem;
import io.wispforest.accessories.client.AccessoriesClient;
import io.wispforest.accessories.mixin.client.GuiGraphicsAccessor;
import io.wispforest.owo.client.OwoClient;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.util.pond.OwoTessellatorExtension;
import java.util.List;
import net.minecraft.class_1058;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_8658;
import net.minecraft.class_8690;
import net.minecraft.class_9801;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.TriConsumer;
import org.joml.Matrix4f;
import org.joml.Vector4f;

public class GuiGraphicsUtils {
    public static void blitSpriteBatched(class_332 guiGraphics, class_2960 sprite, int x, int y, int width, int height) {
        GuiGraphicsUtils.blitSpriteBatched(guiGraphics, sprite, x, y, 0, width, height);
    }

    public static void blitSpriteBatched(class_332 guiGraphics, class_2960 sprite, int x, int y, int blitOffset, int width, int height) {
        class_1058 textureAtlasSprite;
        class_8658 sprites = class_310.method_1551().method_52699();
        class_8690 guiSpriteScaling = sprites.method_52714(textureAtlasSprite = sprites.method_18667(sprite));
        if (guiSpriteScaling instanceof class_8690.class_8693) {
            ((GuiGraphicsAccessor)guiGraphics).callBlitSprite(textureAtlasSprite, x, y, blitOffset, width, height);
        } else if (guiSpriteScaling instanceof class_8690.class_8694) {
            class_8690.class_8694 tile = (class_8690.class_8694)guiSpriteScaling;
            GuiGraphicsUtils.blitTiledSpriteBatched(guiGraphics, textureAtlasSprite, x, y, blitOffset, width, height, 0, 0, tile.comp_1644(), tile.comp_1645(), tile.comp_1644(), tile.comp_1645());
        } else if (guiSpriteScaling instanceof class_8690.class_8691) {
            class_8690.class_8691 nineSlice = (class_8690.class_8691)guiSpriteScaling;
            GuiGraphicsUtils.blitNineSlicedSpriteBatched(guiGraphics, textureAtlasSprite, nineSlice, x, y, blitOffset, width, height);
        }
    }

    private static void blitNineSlicedSpriteBatched(class_332 guiGraphics, class_1058 sprite, class_8690.class_8691 nineSlice, int x, int y, int blitOffset, int width, int height) {
        class_8690.class_8691.class_8692 border = nineSlice.comp_1639();
        int i = Math.min(border.comp_1640(), width / 2);
        int j = Math.min(border.comp_1642(), width / 2);
        int k = Math.min(border.comp_1641(), height / 2);
        int l = Math.min(border.comp_1643(), height / 2);
        GuiGraphicsUtils.batched(guiGraphics, sprite.method_45852(), (BiConsumer<class_287, class_4587>)((BiConsumer)(bufferBuilder, poseStack) -> {
            if (width == nineSlice.comp_1637() && height == nineSlice.comp_1638()) {
                GuiGraphicsUtils.blitSprite(bufferBuilder, poseStack, sprite, nineSlice.comp_1637(), nineSlice.comp_1638(), 0, 0, x, y, blitOffset, width, height);
            } else if (height == nineSlice.comp_1638()) {
                GuiGraphicsUtils.blitSprite(bufferBuilder, poseStack, sprite, nineSlice.comp_1637(), nineSlice.comp_1638(), 0, 0, x, y, blitOffset, i, height);
                GuiGraphicsUtils.blitTiledSprite(bufferBuilder, poseStack, sprite, x + i, y, blitOffset, width - j - i, height, i, 0, nineSlice.comp_1637() - j - i, nineSlice.comp_1638(), nineSlice.comp_1637(), nineSlice.comp_1638());
                GuiGraphicsUtils.blitSprite(bufferBuilder, poseStack, sprite, nineSlice.comp_1637(), nineSlice.comp_1638(), nineSlice.comp_1637() - j, 0, x + width - j, y, blitOffset, j, height);
            } else if (width == nineSlice.comp_1637()) {
                GuiGraphicsUtils.blitSprite(bufferBuilder, poseStack, sprite, nineSlice.comp_1637(), nineSlice.comp_1638(), 0, 0, x, y, blitOffset, width, k);
                GuiGraphicsUtils.blitTiledSprite(bufferBuilder, poseStack, sprite, x, y + k, blitOffset, width, height - l - k, 0, k, nineSlice.comp_1637(), nineSlice.comp_1638() - l - k, nineSlice.comp_1637(), nineSlice.comp_1638());
                GuiGraphicsUtils.blitSprite(bufferBuilder, poseStack, sprite, nineSlice.comp_1637(), nineSlice.comp_1638(), 0, nineSlice.comp_1638() - l, x, y + height - l, blitOffset, width, l);
            } else {
                GuiGraphicsUtils.blitSprite(bufferBuilder, poseStack, sprite, nineSlice.comp_1637(), nineSlice.comp_1638(), 0, 0, x, y, blitOffset, i, k);
                GuiGraphicsUtils.blitTiledSprite(bufferBuilder, poseStack, sprite, x + i, y, blitOffset, width - j - i, k, i, 0, nineSlice.comp_1637() - j - i, k, nineSlice.comp_1637(), nineSlice.comp_1638());
                GuiGraphicsUtils.blitSprite(bufferBuilder, poseStack, sprite, nineSlice.comp_1637(), nineSlice.comp_1638(), nineSlice.comp_1637() - j, 0, x + width - j, y, blitOffset, j, k);
                GuiGraphicsUtils.blitSprite(bufferBuilder, poseStack, sprite, nineSlice.comp_1637(), nineSlice.comp_1638(), 0, nineSlice.comp_1638() - l, x, y + height - l, blitOffset, i, l);
                GuiGraphicsUtils.blitTiledSprite(bufferBuilder, poseStack, sprite, x + i, y + height - l, blitOffset, width - j - i, l, i, nineSlice.comp_1638() - l, nineSlice.comp_1637() - j - i, l, nineSlice.comp_1637(), nineSlice.comp_1638());
                GuiGraphicsUtils.blitSprite(bufferBuilder, poseStack, sprite, nineSlice.comp_1637(), nineSlice.comp_1638(), nineSlice.comp_1637() - j, nineSlice.comp_1638() - l, x + width - j, y + height - l, blitOffset, j, l);
                GuiGraphicsUtils.blitTiledSprite(bufferBuilder, poseStack, sprite, x, y + k, blitOffset, i, height - l - k, 0, k, i, nineSlice.comp_1638() - l - k, nineSlice.comp_1637(), nineSlice.comp_1638());
                GuiGraphicsUtils.blitTiledSprite(bufferBuilder, poseStack, sprite, x + i, y + k, blitOffset, width - j - i, height - l - k, i, k, nineSlice.comp_1637() - j - i, nineSlice.comp_1638() - l - k, nineSlice.comp_1637(), nineSlice.comp_1638());
                GuiGraphicsUtils.blitTiledSprite(bufferBuilder, poseStack, sprite, x + width - j, y + k, blitOffset, i, height - l - k, nineSlice.comp_1637() - j, k, j, nineSlice.comp_1638() - l - k, nineSlice.comp_1637(), nineSlice.comp_1638());
            }
        }));
    }

    private static void blitTiledSpriteBatched(class_332 guiGraphics, class_1058 sprite, int x, int y, int blitOffset, int width, int height, int i, int j, int spriteWidth, int spriteHeight, int nineSliceWidth, int nineSliceHeight) {
        GuiGraphicsUtils.batched(guiGraphics, sprite.method_45852(), (BiConsumer<class_287, class_4587>)((BiConsumer)(bufferBuilder, poseStack) -> {
            if (width <= 0 || height <= 0) {
                return;
            }
            if (spriteWidth <= 0 || spriteHeight <= 0) {
                throw new IllegalArgumentException("Tiled sprite texture size must be positive, got " + spriteWidth + "x" + spriteHeight);
            }
            for (int k = 0; k < width; k += spriteWidth) {
                int l = Math.min(spriteWidth, width - k);
                for (int m = 0; m < height; m += spriteHeight) {
                    int n = Math.min(spriteHeight, height - m);
                    GuiGraphicsUtils.blitSprite(bufferBuilder, poseStack, sprite, nineSliceWidth, nineSliceHeight, i, j, x + k, y + m, blitOffset, l, n);
                }
            }
        }));
    }

    private static void blitTiledSprite(class_287 bufferBuilder, class_4587 poseStack, class_1058 sprite, int x, int y, int blitOffset, int width, int height, int i, int j, int spriteWidth, int spriteHeight, int nineSliceWidth, int nineSliceHeight) {
        if (width <= 0 || height <= 0) {
            return;
        }
        if (spriteWidth <= 0 || spriteHeight <= 0) {
            throw new IllegalArgumentException("Tiled sprite texture size must be positive, got " + spriteWidth + "x" + spriteHeight);
        }
        for (int k = 0; k < width; k += spriteWidth) {
            int l = Math.min(spriteWidth, width - k);
            for (int m = 0; m < height; m += spriteHeight) {
                int n = Math.min(spriteHeight, height - m);
                GuiGraphicsUtils.blitSprite(bufferBuilder, poseStack, sprite, nineSliceWidth, nineSliceHeight, i, j, x + k, y + m, blitOffset, l, n);
            }
        }
    }

    public static <T> void batched(class_332 guiGraphics, class_2960 location, List<T> list, TriConsumer<class_287, class_4587, T> consumer) {
        GuiGraphicsUtils.batched(guiGraphics, location, (BiConsumer<class_287, class_4587>)((BiConsumer)(bufferBuilder, poseStack) -> list.forEach(t -> consumer.accept(bufferBuilder, poseStack, t))));
    }

    public static void batched(class_332 guiGraphics, class_2960 location, BiConsumer<class_287, class_4587> consumer) {
        RenderSystem.setShaderTexture((int)0, (class_2960)location);
        RenderSystem.setShader(class_757::method_34542);
        class_4587 poseStack = guiGraphics.method_51448();
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        consumer.accept((Object)bufferBuilder, (Object)poseStack);
        class_9801 data = bufferBuilder.method_60794();
        if (data != null) {
            class_286.method_43433((class_9801)data);
        }
    }

    private static void blitSprite(class_287 bufferBuilder, class_4587 poseStack, class_1058 sprite, int sliceWidth, int sliceHeight, int uOffset, int vOffset, int x, int y, int blitOffset, int width, int height) {
        if (width == 0 || height == 0) {
            return;
        }
        GuiGraphicsUtils.blitInner(bufferBuilder, poseStack, x, x + width, y, y + height, blitOffset, sprite.method_4580((float)uOffset / (float)sliceWidth), sprite.method_4580((float)(uOffset + width) / (float)sliceWidth), sprite.method_4570((float)vOffset / (float)sliceHeight), sprite.method_4570((float)(vOffset + height) / (float)sliceHeight));
    }

    public static void blit(class_287 bufferBuilder, class_4587 poseStack, int x, int y, int size) {
        GuiGraphicsUtils.blit(bufferBuilder, poseStack, x, y, 0, 0.0f, 0.0f, size, size, size, size);
    }

    public static void blit(class_287 bufferBuilder, class_4587 poseStack, int x1, int y1, int blitOffset, float uOffset, float vOffset, int width, int height, int textureWidth, int textureHeight) {
        float minU = uOffset / (float)textureWidth;
        float maxU = (uOffset + (float)width) / (float)textureWidth;
        float minV = vOffset / (float)textureHeight;
        float maxV = (vOffset + (float)height) / (float)textureHeight;
        GuiGraphicsUtils.blitInner(bufferBuilder, poseStack, x1, x1 + width, y1, y1 + height, blitOffset, minU, maxU, minV, maxV);
    }

    private static void blitInner(class_287 bufferBuilder, class_4587 poseStack, int x1, int x2, int y1, int y2, int blitOffset, float minU, float maxU, float minV, float maxV) {
        Matrix4f matrix4f = poseStack.method_23760().method_23761();
        bufferBuilder.method_22918(matrix4f, (float)x1, (float)y1, (float)blitOffset).method_22913(minU, minV);
        bufferBuilder.method_22918(matrix4f, (float)x1, (float)y2, (float)blitOffset).method_22913(minU, maxV);
        bufferBuilder.method_22918(matrix4f, (float)x2, (float)y2, (float)blitOffset).method_22913(maxU, maxV);
        bufferBuilder.method_22918(matrix4f, (float)x2, (float)y1, (float)blitOffset).method_22913(maxU, minV);
    }

    public static void blitWithAlpha(class_332 ctx, class_2960 atlasLocation, int x, int y, float uOffset, float vOffset, int width, int height, int textureWidth, int textureHeight, Vector4f alphaValues) {
        GuiGraphicsUtils.blitWithAlpha(ctx, atlasLocation, x, y, width, height, uOffset, vOffset, width, height, textureWidth, textureHeight, alphaValues);
    }

    private static void blitWithAlpha(class_332 ctx, class_2960 atlasLocation, int x, int y, int width, int height, float uOffset, float vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight, Vector4f alphaValues) {
        GuiGraphicsUtils.blitWithAlpha(ctx, atlasLocation, x, x + width, y, y + height, 0, uWidth, vHeight, uOffset, vOffset, textureWidth, textureHeight, alphaValues);
    }

    private static void blitWithAlpha(class_332 ctx, class_2960 atlasLocation, int x1, int x2, int y1, int y2, int blitOffset, int uWidth, int vHeight, float uOffset, float vOffset, int textureWidth, int textureHeight, Vector4f alphaValues) {
        GuiGraphicsUtils.innerBlitWithAlpha(ctx, atlasLocation, x1, x2, y1, y2, blitOffset, (uOffset + 0.0f) / (float)textureWidth, (uOffset + (float)uWidth) / (float)textureWidth, (vOffset + 0.0f) / (float)textureHeight, (vOffset + (float)vHeight) / (float)textureHeight, alphaValues);
    }

    private static void innerBlitWithAlpha(class_332 ctx, class_2960 atlasLocation, int x1, int x2, int y1, int y2, int blitOffset, float minU, float maxU, float minV, float maxV, Vector4f alphaValues) {
        RenderSystem.setShaderTexture((int)0, (class_2960)atlasLocation);
        RenderSystem.setShader(class_757::method_34543);
        RenderSystem.enableBlend();
        Matrix4f matrix4f = ctx.method_51448().method_23760().method_23761();
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        bufferBuilder.method_22918(matrix4f, (float)x1, (float)y1, (float)blitOffset).method_22913(minU, minV).method_22915(1.0f, 1.0f, 1.0f, alphaValues.x);
        bufferBuilder.method_22918(matrix4f, (float)x1, (float)y2, (float)blitOffset).method_22913(minU, maxV).method_22915(1.0f, 1.0f, 1.0f, alphaValues.z);
        bufferBuilder.method_22918(matrix4f, (float)x2, (float)y2, (float)blitOffset).method_22913(maxU, maxV).method_22915(1.0f, 1.0f, 1.0f, alphaValues.w);
        bufferBuilder.method_22918(matrix4f, (float)x2, (float)y1, (float)blitOffset).method_22913(maxU, minV).method_22915(1.0f, 1.0f, 1.0f, alphaValues.y);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        RenderSystem.disableBlend();
    }

    public static void blitWithColor(class_332 ctx, class_2960 atlasLocation, int x, int y, float uOffset, float vOffset, int width, int height, int textureWidth, int textureHeight, float red, float green, float blue, float alpha) {
        GuiGraphicsUtils.blitWithColor(ctx, atlasLocation, x, y, width, height, uOffset, vOffset, width, height, textureWidth, textureHeight, red, green, blue, alpha);
    }

    private static void blitWithColor(class_332 ctx, class_2960 atlasLocation, int x, int y, int width, int height, float uOffset, float vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight, float red, float green, float blue, float alpha) {
        GuiGraphicsUtils.blitWithColor(ctx, atlasLocation, x, x + width, y, y + height, 0, uWidth, vHeight, uOffset, vOffset, textureWidth, textureHeight, red, green, blue, alpha);
    }

    private static void blitWithColor(class_332 ctx, class_2960 atlasLocation, int x1, int x2, int y1, int y2, int blitOffset, int uWidth, int vHeight, float uOffset, float vOffset, int textureWidth, int textureHeight, float red, float green, float blue, float alpha) {
        GuiGraphicsUtils.innerBlitWithColor(ctx, atlasLocation, x1, x2, y1, y2, blitOffset, (uOffset + 0.0f) / (float)textureWidth, (uOffset + (float)uWidth) / (float)textureWidth, (vOffset + 0.0f) / (float)textureHeight, (vOffset + (float)vHeight) / (float)textureHeight, red, green, blue, alpha);
    }

    private static void innerBlitWithColor(class_332 ctx, class_2960 atlasLocation, int x1, int x2, int y1, int y2, int blitOffset, float minU, float maxU, float minV, float maxV, float red, float green, float blue, float alpha) {
        RenderSystem.setShaderTexture((int)0, (class_2960)atlasLocation);
        RenderSystem.setShader(class_757::method_34543);
        RenderSystem.enableBlend();
        Matrix4f matrix4f = ctx.method_51448().method_23760().method_23761();
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        bufferBuilder.method_22918(matrix4f, (float)x1, (float)y1, (float)blitOffset).method_22913(minU, minV).method_22915(red, green, blue, alpha);
        bufferBuilder.method_22918(matrix4f, (float)x1, (float)y2, (float)blitOffset).method_22913(minU, maxV).method_22915(red, green, blue, alpha);
        bufferBuilder.method_22918(matrix4f, (float)x2, (float)y2, (float)blitOffset).method_22913(maxU, maxV).method_22915(red, green, blue, alpha);
        bufferBuilder.method_22918(matrix4f, (float)x2, (float)y1, (float)blitOffset).method_22913(maxU, minV).method_22915(red, green, blue, alpha);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        RenderSystem.disableBlend();
    }

    public static void drawWithSpectrum(class_332 ctx, int x, int y, int blitOffset, int width, int height, class_1058 sprite, float alpha) {
        GuiGraphicsUtils.innerDrawWithSpectrum(ctx, sprite.method_45852(), x, x + width, y, y + height, blitOffset, sprite.method_4594(), sprite.method_4577(), sprite.method_4593(), sprite.method_4575(), new Vector4f(alpha));
    }

    public static void drawWithSpectrum(class_332 ctx, int x, int y, int blitOffset, int width, int height, class_1058 sprite, Vector4f alphaValues) {
        GuiGraphicsUtils.innerDrawWithSpectrum(ctx, sprite.method_45852(), x, x + width, y, y + height, blitOffset, sprite.method_4594(), sprite.method_4577(), sprite.method_4593(), sprite.method_4575(), alphaValues);
    }

    private static void innerDrawWithSpectrum(class_332 ctx, class_2960 atlasLocation, int x1, int x2, int y1, int y2, int blitOffset, float minU, float maxU, float minV, float maxV, Vector4f alphaValues) {
        RenderSystem.setShaderTexture((int)0, (class_2960)atlasLocation);
        RenderSystem.enableBlend();
        Matrix4f matrix4f = ctx.method_51448().method_23760().method_23761();
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        bufferBuilder.method_22918(matrix4f, (float)x1, (float)y1, (float)blitOffset).method_22913(minU, minV).method_22915(1.0f, 1.0f, 1.0f, alphaValues.x);
        bufferBuilder.method_22918(matrix4f, (float)x1, (float)y2, (float)blitOffset).method_22913(minU, maxV).method_22915(0.0f, 1.0f, 1.0f, alphaValues.z);
        bufferBuilder.method_22918(matrix4f, (float)x2, (float)y2, (float)blitOffset).method_22913(maxU, maxV).method_22915(0.0f, 1.0f, 1.0f, alphaValues.w);
        bufferBuilder.method_22918(matrix4f, (float)x2, (float)y1, (float)blitOffset).method_22913(maxU, minV).method_22915(1.0f, 1.0f, 1.0f, alphaValues.y);
        AccessoriesClient.SPECTRUM_PROGRAM.use();
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        RenderSystem.disableBlend();
    }

    public static void drawRectOutlineWithSpectrum(OwoUIDrawContext ctx, int x, int y, int z, int width, int height, float alpha, boolean vertical) {
        ctx.recordQuads();
        GuiGraphicsUtils.drawRectOutlineWithSpectrumWithoutRecord(ctx, x, y, z, width, height, alpha, vertical);
        ctx.submitQuads();
    }

    public static void drawRectOutlineWithSpectrumWithoutRecord(OwoUIDrawContext ctx, int x, int y, int z, int width, int height, float alpha, boolean vertical) {
        GuiGraphicsUtils.innerFill((class_332)ctx, x, y, x + width, y + 1, 0, alpha, !vertical);
        GuiGraphicsUtils.innerFill((class_332)ctx, x, y + height - 1, x + width, y + height, 0, alpha, !vertical);
        GuiGraphicsUtils.innerFill((class_332)ctx, x, y + 1, x + 1, y + height - 1, 0, alpha, vertical);
        GuiGraphicsUtils.innerFill((class_332)ctx, x + width - 1, y + 1, x + width, y + height - 1, 0, alpha, vertical);
    }

    private static void innerFill(class_332 ctx, int minX, int minY, int maxX, int maxY, int z, float alpha, boolean vertical) {
        OwoUIDrawContext context;
        float topValue;
        OwoUIDrawContext context2;
        int i;
        RenderSystem.enableBlend();
        Matrix4f matrix4f = ctx.method_51448().method_23760().method_23761();
        if (minX < maxX) {
            i = minX;
            minX = maxX;
            maxX = i;
        }
        if (minY < maxY) {
            i = minY;
            minY = maxY;
            maxY = i;
        }
        if (ctx instanceof OwoUIDrawContext && (context2 = (OwoUIDrawContext)ctx).recording()) {
            ((OwoTessellatorExtension)class_289.method_1348()).owo$skipNextBegin();
        }
        class_287 builder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        float multiplier = (float)((double)System.currentTimeMillis() / 20.0 % 360.0 / 360.0);
        float bottomValue = topValue = 1.0f - multiplier;
        builder.method_22918(matrix4f, (float)minX, (float)minY, (float)z).method_22915(topValue, 1.0f, 1.0f, alpha);
        builder.method_22918(matrix4f, (float)minX, (float)maxY, (float)z).method_22915(vertical ? bottomValue : topValue, 1.0f, 1.0f, alpha);
        builder.method_22918(matrix4f, (float)maxX, (float)maxY, (float)z).method_22915(bottomValue, 1.0f, 1.0f, alpha);
        builder.method_22918(matrix4f, (float)maxX, (float)minY, (float)z).method_22915(vertical ? topValue : bottomValue, 1.0f, 1.0f, alpha);
        OwoClient.HSV_PROGRAM.use();
        if (ctx instanceof OwoUIDrawContext && (context = (OwoUIDrawContext)ctx).recording()) {
            ((OwoTessellatorExtension)class_289.method_1348()).owo$setStoredBuilder(builder);
            return;
        }
        class_286.method_43433((class_9801)builder.method_60800());
        RenderSystem.disableBlend();
    }
}

